<?php get_header(); ?>

<div class="container">
	<?php 
	if ($post->post_parent) {
		$cat_id = wp_get_post_parent_id(get_the_ID());
		$query_id = wp_get_post_parent_id(get_the_ID());
	} else {
		$cat_id = get_the_ID();
		$query_id = get_the_ID();
	}
	$terms = get_the_terms( $cat_id, 'building_category');
	$term = array_pop($terms);
	
	// $terms = get_the_terms( get_the_ID(), 'building_category');
	// $term = array_pop($terms);
	
	$cat_banner = get_field('main_banner',$term);
	$cat_logo = get_field('main_logo',$term); ?>
	
	<?php if ($cat_banner) { ?>
		<img src="<?php echo $cat_banner['url']; ?>" class="main-banner">
	<?php } ?>
	
	<?php if ( function_exists('yoast_breadcrumb')) {
		yoast_breadcrumb('
			<div class="breadcrumbs-box"><p id="breadcrumbs">','</p></div>
		');
	} ?>
	
	<div class="row title-box">
		<?php if ($cat_logo) { ?>
			<div class="col-sm-18">
		<?php } else { ?>
			<div class="col-sm-24">
		<?php } ?>
				<div class="title-box__container">
					<h1 class="h2"><?php echo get_the_title($query_id); ?></h1>
					<?php if (get_field('address',$term)) { ?>
						<p class="address"><?php the_field('address',$term); ?></p>
					<?php } ?>
				</div>
			</div>
		<?php if ($cat_logo) { ?>
			<div class="col-sm-6 text-right">
				<img src="<?php echo $cat_logo['url']; ?>" class="investment-logo">
			</div>
		<?php } ?>
	</div>
	
	
	
	<?php $post_id = get_the_ID();
	$parent = new WP_Query( 
		array(
			'post_type' => 'buildings',
			'post_parent' => $query_id,
			'orderby' => 'menu_order',
			'order' => 'ASC',
			'post_status' => 'publish',
			'posts_per_page' => -1,
			'depth'	=> '1'
		)
	);	
	wp_reset_postdata();
	if ( $parent->have_posts() ) { ?>
		<div class="investment_menu">
			<a href="<?php echo get_post_permalink($query_id); ?>" class="investment_menu__link<?php if (!$post->post_parent) echo ' active'; ?>">Opis</a>
			<?php while ( $parent->have_posts() ) { $parent->the_post(); ?>				
				<a href="<?php the_permalink(); ?>" class="investment_menu__link<?php if (get_the_ID() == $post_id) echo ' active'; ?>"><?php the_title(); ?></a>
			<?php } ?>
		</div>
	<?php }
	wp_reset_query(); ?>
	
	
	
	<?php $investment_content = get_field('investment_content'); ?>
	
	<?php if ($investment_content == 'desc') { ?>
		<!-- INVESTMENT - description -->
		<?php if (get_field('desc_title')) { ?>
			<h2 class="main-header text-center"><?php the_field('desc_title'); ?></h2>
		<?php } elseif (get_field('desc_title','option')) { ?>
			<h2 class="main-header text-center"><?php the_field('desc_title','option'); ?></h2>
		<?php } ?>
		<?php 
		if (get_field('desc_text') or have_rows('desc_photos')) { ?>
			<div class="row">
				<div class="col-sm-<?php if (get_field('desc_text') and have_rows('desc_photos')) echo '14'; elseif (get_field('desc_text')) echo '24'; ?>">
					<?php the_field('desc_text'); ?>
				</div>
				<div class="col-sm-<?php if (get_field('desc_text') and have_rows('desc_photos')) echo '10'; elseif (!get_field('desc_text') and have_rows('desc_photos')) echo '24'; ?> desc-photos">
					<?php $d = 1;$dp = 0;
					while( have_rows('desc_photos') ) { the_row();
						$desc_photo = get_sub_field('photo');
						if ($desc_photo) ?>
							<a href="<?php echo $desc_photo['url']; ?>" rel="lightbox" style="top:<?php echo $dp; ?>px;">
								<img src="<?php echo $desc_photo['url']; ?>">
							</a>
						<?php $dp = $dp + 150;
						$d++;
					} ?>
				</div>
			</div>
		<?php } ?>
		
		<?php if( have_rows('desc_links') ) { ?>
			<div class="row">
				<div class="col-sm-24 links-box text-center">
					<?php $delay = 50;
					while ( have_rows('desc_links') ) { the_row();
						$link_file = get_sub_field('link_file');
						$link_cat = get_sub_field('link_cat'); ?>
						<a href="<?php if (get_sub_field('link_source') == 'site' and get_sub_field('link_site')) the_sub_field('link_site'); elseif (get_sub_field('link_source') == 'url' and get_sub_field('link_url')) the_sub_field('link_url'); elseif (get_sub_field('link_source') == 'cat' and get_term_link($link_cat)) echo $link_file['url']; elseif (get_sub_field('link_source') == 'file' and $link_file) echo $link_file['url']; ?>" class="wow fadeIn <?php if (get_sub_field('link_type') == 'default') echo 'btn btn-default';  elseif (get_sub_field('link_type') == 'primary') echo 'btn btn-primary'; else echo 'normal-link'; ?>"<?php if (get_sub_field('link_source') == 'url' and (get_sub_field('link_url') or $link_file)) { ?> target="_blank"<?php } ?> data-wow-delay="<?php echo $delay; ?>ms">
							<?php if (get_sub_field('link_content')) { ?>
								<?php the_sub_field('link_content') ?>
							<?php } else { ?>
								Czytaj więcej
							<?php } ?>
						</a>
					<?php $delay + 200;
					} ?>
				</div>
			</div>
		<?php } ?>
		
	<?php } elseif ($investment_content == 'vr') { ?>
		<!-- INVESTMENT - virtual reality -->
		<?php if (get_field('vr_title')) { ?>
			<h2 class="main-header text-center"><?php the_field('vr_title'); ?></h2>
		<?php } elseif (get_field('vr_title','option')) { ?>					
			<h2 class="main-header text-center"><?php the_field('vr_title','option'); ?></h2>
		<?php } ?>
		
		<?php if (get_field('vr_code')) the_field('vr_code'); ?>
		
	<?php } elseif ($investment_content == '3d') { ?>
		<!-- INVESTMENT - 3d search -->	
		<?php if( get_field('building_image') ): ?>
			<div class="row marginbottom clear">
				<div class="col-sm-24">
					<?php if( get_field('3d_title') ) { ?>
						<h2 class="main-header main-header"><?php the_field('3d_title'); ?></h2>
					<?php } elseif (get_field('3d_title','option')) { ?>					
						<h2 class="main-header text-center"><?php the_field('3d_title','option'); ?></h2>
					<?php } ?>
				</div>
				<div class="col-sm-24 text-center">
					
					<div id="apartments">
						<img id="apartments_background" src="<?php the_field('building_image'); ?>" />
						<div id="apartments_canvas_cont"></div>
					</div>

					<?php
					$floor_link = get_field('floor_link');
					$apartments = get_field('floors');

					foreach ($apartments as &$a) {
						if ($a['apartment_id']) {
							$a['status'] = get_field('status', $a['apartment_id']);
							$a['size'] = get_field('size', $a['apartment_id']);
							$a['size_usable'] = get_field('size_usable', $a['apartment_id']);
							$a['rooms'] = get_field('rooms', $a['apartment_id']);
							$a['link'] = get_post_permalink($a['apartment_id']);
							$a['url'] = get_field('link', $a['apartment_id']);
							$a['premises'] = get_field('link_premisses', $a['apartment_id']);
						} else if ($a['link']) {
							$linked_post_id = url_to_postid($a['link']);

							if ($linked_post_id != 0) {
								$post_type = get_post_type($linked_post_id);
								if ($post_type == 'floors') {
									// WŁĄCZENIE POKAZYWANIA DOSTĘPNOŚCI
									$show_counted_status = false;
									$show_counted_status = get_field('show_counted_status', $linked_post_id);
									if ($show_counted_status === null)
										$show_counted_status = true;

									if ($show_counted_status and !get_field('not_show_counted_status')) {
										$num_free_apartments = get_field('num_free_apartments', $linked_post_id);
										$num_sold_apartments = get_field('num_sold_apartments', $linked_post_id);
										$num_booked_apartments = get_field('num_booked_apartments', $linked_post_id);

										$a['floor'] .= ' – Dostępnych: '.$num_free_apartments.' Sprzedanych: '.$num_sold_apartments.' Zarezerwowanych: '.$num_booked_apartments;
										// $a['floor'] .= ' – Dostępnych: '.$num_free_apartments.', Zarezerwowanych: '.$num_booked_apartments;
									}
								}
							}
						}
						$floor = get_field('floor');
						$link = get_field('link');
						$link_to_premisses = get_field('link_to_premisses');


					}
					unset($a);
					?>
					<script>
					var color_free = '#9EC02E';
					var color_taken = '#DA5317';
					var apartments = <?php echo wp_json_encode($apartments); ?>;
					var link = <?php echo wp_json_encode($link); ?>;
					var floor = <?php echo wp_json_encode($floor); ?>;
					// var floor_txt = <?php echo '<span class="invest_desc">' . wp_json_encode($floor) . '</span>'; ?>;
					var floor_link = <?php echo wp_json_encode($floor_link); ?>;
					var link_to_premisses = <?php echo wp_json_encode($link_to_premisses); ?>;
					var apartment = $("#apartments");
					var backgroundImg = $("#apartments_background");
					var konvaContainer = $("#apartments_canvas_cont");
					var width = 0;
					var height = 0;
					var scale = 1;

					var updateTooltip = function(tooltip, x, y, text) {
						tooltip.getText().setText(text);
						tooltip.setPosition({
							x : x,
							y : y
						});
						tooltip.show();
					}

					var calcSizes = function() {
						scale = apartment.width() / backgroundImg[0].naturalWidth;
						width = apartment.width();
						height = backgroundImg[0].naturalHeight * scale;
						apartment.height(height);
						backgroundImg.width(width);
						backgroundImg.height(height);
					}

					var setupStage = function() {
						var stage = new Konva.Stage({
							container: 'apartments_canvas_cont',
							width: width,
							height: height
						});

						var tooltipLayer = new Konva.Layer();
						var tooltip = new Konva.Label({
							opacity: 0.75,
							offset: 10,
							visible: false,
							listening: false
						});

						tooltip.add(new Konva.Tag({
							fill: 'black',
							pointerDirection: 'down',
							pointerWidth: 10,
							pointerHeight: 10,
							lineJoin: 'round',
							shadowColor: 'black',
							shadowBlur: 10,
							shadowOffset: 10,
							shadowOpacity: 0.5
						}));

						tooltip.add(new Konva.Text({
							text: '',
							fontFamily: 'Lato',
							fontSize: 18,
							padding: 5,
							fill: 'white'
						}));

						tooltipLayer.add(tooltip);

						var shapesLayer = new Konva.Layer({
							scale: {x: scale, y: scale}
						});
						// event handlers
						var floorMouseOver = function(evt) {
							var shape = evt.target;
							if (shape) {
								shape.setOpacity(0.5);
								shapesLayer.draw();
								document.body.style.cursor = 'pointer';
							}
						}
						var floorMouseOut =  function(evt) {
							var shape = evt.target;
							if (shape) {
								if (floor_link) {
									for (var j = 0; j < apartments.length; ++j) {
										var status = apartments[j].status;
										if (status == 'free') {
											shape.setOpacity(0);
										} else {
											shape.setOpacity(0.3);
										}
									}
								} else {
									shape.setOpacity(0);
								}
								shapesLayer.draw();
								tooltip.hide();
								tooltipLayer.draw();
								document.body.style.cursor = 'default';
							}
						}
						var floorMouseMove = function(evt) {
							var shape = evt.target;
							if (shape) {
								var mousePos = stage.getPointerPosition();
								var x = (mousePos.x);
								var y = (mousePos.y - 5);
								updateTooltip(tooltip, x, y, shape.attrs.key);
								tooltipLayer.batchDraw();
							}
						}
						var floorClick = function(evt) {
							var shape = evt.target;
							if (shape && shape.attrs.link)
								location.href = shape.attrs.link;
						}
						// draw areas
						if (apartments) {
							for (var i = 0; i < apartments.length; ++i) {
								var status = apartments[i].status;
								var size = apartments[i].size;
								var size_usable = apartments[i].size_usable;
								var main_size = size_usable ? size_usable : size;
								var rooms = apartments[i].rooms;
								if (floor_link) {
									if (status == 'free') {
										var color = '#9EC02E';
										var shape = new Konva.Line({
											points: JSON.parse(apartments[i].points),
											opacity: 0,
											fill: color,
											closed : true,
											// custom attr
											key: apartments[i].floor + ' | ' + main_size + ' mkw | pokoi: ' + rooms,
											link: apartments[i].link

										});
									} else if (status == 'booked') {
										var color = '#dab817';
										var shape = new Konva.Line({
											points: JSON.parse(apartments[i].points),
											opacity: 0.3,
											fill: color,
											closed : true,
											// custom attr
											key: apartments[i].floor + ' | ' + main_size + ' mkw - zarezerwowane',
											link: apartments[i].link

										});
									} else {
										var color = '#DA5317';
										var shape = new Konva.Line({
											points: JSON.parse(apartments[i].points),
											opacity: 0.3,
											fill: color,
											closed : true,
											// custom attr
											key: apartments[i].floor + ' | sprzedane'

										});
									}
								} else {
									var color = '#006985';
									var shape = new Konva.Line({
										points: JSON.parse(apartments[i].points),
										fill: color,
										opacity: 0,
										closed : true,
										// custom attr
										key: apartments[i].floor,
										link: apartments[i].link_to_premisses ? apartments[i].link_premisses : apartments[i].link
									});
								}

								shape.on('mouseover', floorMouseOver);
								shape.on('mouseout', floorMouseOut);
								shape.on('mousemove', floorMouseMove);
								shape.on('click tap', floorClick);

								shapesLayer.add(shape);
							}
						}


						var lastTouchedShape = null;
						stage.on('touchmove', function(evt) {
							var shape = evt.target;
							if (shape) {
								if (lastTouchedShape != shape && lastTouchedShape != null) {
									lastTouchedShape.setOpacity(0);
								}
								lastTouchedShape = shape;
								shape.setOpacity(0.5);
								shapesLayer.draw();

								var mousePos = stage.getPointerPosition();
								var x = (mousePos.x);
								var y = (mousePos.y - 20);
								updateTooltip(tooltip, x, y, shape.attrs.key);
								tooltipLayer.batchDraw();
							} else if (lastTouchedShape) {
								lastTouchedShape.setOpacity(0);
								lastTouchedShape.draw();
								tooltip.hide();
								tooltipLayer.draw();
								lastTouchedShape = null;
							}
						});

						stage.on('touchend', function(evt) {
							if (lastTouchedShape) {
								lastTouchedShape.setOpacity(0);
								lastTouchedShape.draw();
								tooltip.hide();
								tooltipLayer.draw();
								lastTouchedShape = null;
							}
						});

						stage.add(shapesLayer);
						stage.add(tooltipLayer);

						$(window).resize(function(event) {
							calcSizes();
							stage.width(width);
							stage.height(height);
							shapesLayer.scale({x: scale, y: scale});
						});
					}

					var positionsInitialized = false;
					backgroundImg.load(function() {
						if (!positionsInitialized) {
							calcSizes();

							var positionCss = {
								position: "absolute",
								top: 0,
								left: 0
							};
							backgroundImg.css(positionCss);
							konvaContainer.css(positionCss);

							setupStage();

							positionsInitialized = true;
						}
					});
					if (backgroundImg[0].complete)
						backgroundImg.load();
					</script>

				</div>
			</div>
		<?php endif; ?>
		
	<?php } elseif ($investment_content == 'gallery') { ?>
		<!-- INVESTMENT - gallery -->
		<?php if( get_field('gallery_title') ) { ?>
			<h2 class="main-header main-header text-center"><?php the_field('gallery_title'); ?></h2>
		<?php } elseif (get_field('gallery_title','option')) { ?>					
			<h2 class="main-header text-center"><?php the_field('gallery_title','option'); ?></h2>
		<?php } ?>
		<?php if( (have_rows('gallery')) ) { ?>
			<div class="gallery-box row marginbottom">
				<div class="col-sm-24">
					<div class="filters marginbottom clear">
						<?php $ga = 0;
						while ( (have_rows('gallery')) ) : the_row(); ?>				
							<?php if (get_sub_field('gallery_name')) { ?>
								<a class="button<?php if ($ga == 0) echo ' selected'; ?>" data-filter=".<?php echo 'category-'.$ga; ?>"><?php the_sub_field('gallery_name'); ?></a>
							<?php } ?>					
						<?php $ga++;
						endwhile; ?>
					</div>
					<div class="gallery isotope-grid">
						<div class="grid-sizer"></div>
						<div class="gutter-sizer"></div>
						<?php $g = 0;
						while ( (have_rows('gallery')) ) : the_row(); ?>					
							<?php $gallery_images = get_sub_field('gallery_images'); ?>						
							<?php foreach( $gallery_images as $imagegal ) { ?>							
								<?php if( $imagegal['description'] ): ?>
									<div class="grid-item<?php echo ' category-'.$g; ?>">
										<a href="" data-toggle="modal" data-target="#video-<?php echo $imagegal['ID']; ?>">
											<div class="thumbnail-200 thumbnail-cover" style="background-image:url(<?php echo $imagegal['url']; ?>)">
												<div class="gallery-video-zoom">
													<div class="border"></div>
													<i class="fa fa-play-circle"></i>
												</div>
											</div>
										</a>
									</div>
									<div class="modal fade" id="video-<?php echo $imagegal['ID']; ?>" tabindex="-1" role="dialog" aria-labelledby="label-<?php echo $imagegal['ID']; ?>">
										<div class="modal-dialog modal-lg">
											<div class="modal-content">
												<div class="modal-header">
													<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
													<h4 class="modal-title" id="label-<?php echo $imagegal['ID']; ?>"><?php echo $imagegal['alt']; ?></h4>
												</div>
												<div class="modal-body">
													<iframe width="100%" height="450" src="<?php echo $imagegal['description']; ?>" frameborder="0" allowfullscreen></iframe>
												</div>
											</div>
										</div>
									</div>
								<?php else : ?>
									<div class="grid-item<?php echo ' category-'.$g; ?>">
										<a href="<?php echo $imagegal['url']; ?>" rel="lightbox" class="gallery-img hover-link" title="<?php echo $imagegal['caption']; ?>">
											<div class="border"></div>
											<div class="thumbnail-200 thumbnail-cover" style="background-image: url(<?php echo $imagegal['sizes']['large']; ?>);"></div>
										</a>
									</div>
								<?php endif; ?>
							<?php }
							$g++; ?>					
						<?php endwhile; ?>
					</div>
				</div>		
			</div>
		<?php } ?>
		
	<?php } elseif ($investment_content == 'flats') { ?>
		<!-- INVESTMENT - flats -->
		<div class="flats marginbottom clear">
			<?php if (get_field('flats_title')) { ?>					
				<h2 class="main-header text-center"><?php the_field('flats_title'); ?></h2>
			<?php } elseif (get_field('flats_title','option')) { ?>					
				<h2 class="main-header text-center"><?php the_field('flats_title','option'); ?></h2>
			<?php } ?>
			
			<?php if (get_field('show_list')) {
				$invest_title = get_the_title($query_id);
				$apartments = new WP_Query( 
					array(
						'post_type' => 'apartments',
						'orderby' => 'menu_order',
						'order' => 'ASC',
						'post_status' => 'publish',
						'posts_per_page' => 10,
						'tax_query' => array(
							array (
								'taxonomy' => 'apartment_category',
								'field' => 'slug',
								'terms' => $term,
							)
						),
						'paged' => $paged
					)
				);	
				wp_reset_postdata();
				if ( $apartments->have_posts() ) { ?>
					<div class="apartment-list">
						<?php while ( $apartments->have_posts() ) { $apartments->the_post(); ?>
							<div class="apartment-item">
								<a href="<?php the_permalink(); ?>" class="link-absolute"></a>
								<div class="row">
									<div class="col-sm-4">
										<?php if (has_post_thumbnail()) {
											$thumb_id = get_post_thumbnail_id($post->ID); ?>
											<img src="<?php echo wp_get_attachment_url($thumb_id); ?>">
										<?php } ?>
									</div>
									<div class="col-sm-16">
										<h3><?php echo $invest_title; ?> <span>Mieszkanie <?php the_title(); ?></span></h3>
										<div class="row display-flex">
											<div class="col-sm-17 display-flex-middle">										
												<?php $status_field = get_field_object('status');
												$value = $status_field['value'];
												$status = $status_field['choices'][ $value ];
												if (get_field('status')) { ?>
													<p class="status <?php the_field('status'); ?>"><?php echo $status; ?></p>
												<?php } ?>										
											</div>					
											<div class="col-sm-7 display-flex-middle">
												<?php $price_all = get_field('promotion');
												if (get_field('promotion')) { ?>
													<p class="promotion promotion-<?php the_field('promotion'); ?> <?php the_field('promotion_type'); ?>">% promocja</p>
												<?php } ?>										
											</div>
										</div>
										<div class="row display-flex">
											<div class="col-sm-17 display-flex-middle">
												<p class="apartment-details">
													<?php if (get_field('size')) { ?>Metraż: <strong><?php the_field('size'); ?> m<sup>2</sup></strong>  <?php } ?>
													<?php if (get_field('rooms')) { ?>Ilość pokoi: <strong><?php the_field('rooms'); ?> m<sup>2</sup></strong>  <?php } ?>
													<?php if (get_field('floor')) { ?>Piętro: <strong><?php the_field('floor'); ?></strong>  <?php } ?>
													<?php if (get_field('balcony')) { ?>Balkon: <strong><?php the_field('balcony'); ?> m<sup>2</sup></strong>  <?php } ?>
												</p>
											</div>					
											<div class="col-sm-7 display-flex-middle">
												<?php $price_all = get_field('price_all');
												if (get_field('show_price') and $price_all) {
													$price = number_format( $price_all, 0, ',', ' '); ?>
													<p class="price"><span class="visible-xs-inline-block visible-sm-inline-block">Cena:  </span><?php echo $price; ?> zł</p>
												<?php } else { ?>
													<a href="" class="btn btn-default">Zapytaj o cenę</a>
												<?php } ?>
											</div>
										</div>
									</div>
									<div class="col-sm-4 text-right">
										<?php if (has_post_thumbnail()) {
											$thumb_id = get_post_thumbnail_id($post->ID); ?>
											<img src="<?php echo wp_get_attachment_url($thumb_id); ?>">
										<?php } ?>
									</div>
								</div>
							</div>
						<?php } ?>
					</div>
				<?php }
				wp_reset_query();
			} ?>
			
			
			
			<?php if (get_field('apartment_search')) { ?>
				<div class="marginbottom">
					<?php the_field('apartment_search'); ?>
				</div>
			<?php } ?>
			<?php if (get_field('content')) { ?>
				<div class="marginbottom">
					<?php the_field('content'); ?>
				</div>
			<?php } ?>
		</div>
		
	<?php } elseif ($investment_content == 'location') { ?>
		<!-- INVESTMENT - location -->		
		<div class="location marginbottom clear">
			<?php if (get_field('localisation_title')) { ?>					
				<h2 class="main-header text-center"><?php the_field('localisation_title'); ?></h2>
			<?php } elseif (get_field('localisation_title','option')) { ?>					
				<h2 class="main-header text-center"><?php the_field('localisation_title','option'); ?></h2>
			<?php } ?>

			<div class="row">
				<?php if (get_field('map_code')) { ?>
					<div class="col-sm-24">
						<?php the_field('map_code'); ?>
					</div>
				<?php } ?>
				<?php if (get_field('location_text')) { ?>
					<div class="location-text col-sm-24 margintop marginbottom">
						<?php the_field('location_text'); ?>
					</div>
				<?php } ?>
				<?php $location_gallery = get_field('location_gallery');

				if ($location_gallery) { ?>
					<div id="carousel-location" class="carousel carousel-fade slide col-sm-24" data-ride="carousel">
						<div class="carousel-inner" role="listbox">
							<?php $location_gallery_count = count($location_gallery);
							$i = 1; ?>							
							<?php foreach ($location_gallery as $key => $image) { ?>								
								<div class="item<?php if ($i == 1) echo ' active'; ?>">
									<p class="slider-counter text-center"><?php echo $i . ' / ' . $location_gallery_count; ?></p>
									
									<div class="row">
										<div class="col-sm-6 slider-nav hidden-xs transition">
											<a href="#carousel-location" data-slide="prev">
												<div class="thumbnail-200 thumbnail-cover" style="background-image:url(<?php if(isset($location_gallery[$key - 1])) echo $location_gallery[$key - 1]['url']; else echo $location_gallery[$location_gallery_count-1]['url']; ?>)"></div>
											</a>
										</div>
											
										<div class="col-sm-12">
											<?php if( $image['description'] ): ?>
												<a href="" data-toggle="modal" data-target="#loc-video-<?php echo $image['ID']; ?>">
													<div class="thumbnail-400 thumbnail-cover" style="background-image:url(<?php echo $image['url']; ?>)">
														<div class="gallery-video-zoom">
															<i class="fa fa-play-circle"></i>
														</div>
													</div>
												</a>
												<div class="modal fade" id="loc-video-<?php echo $image['ID']; ?>" tabindex="-1" role="dialog" aria-labelledby="label-<?php echo $image['ID']; ?>">
													<div class="modal-dialog modal-lg">
														<div class="modal-content">
															<div class="modal-header">
																<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
																<h4 class="modal-title" id="label-<?php echo $image['ID']; ?>"><?php echo $image['alt']; ?></h4>
															</div>
															<div class="modal-body">
																<iframe width="100%" height="450" src="<?php echo $image['description']; ?>" frameborder="0" allowfullscreen></iframe>
															</div>
														</div>
													</div>
												</div>
											<?php else : ?>
												<a href="<?php echo $image['url']; ?>" rel="lightbox" class="gallery-img hover-link" title="<?php echo $image['caption']; ?>">
													<div class="thumbnail-400 thumbnail-cover" style="background-image:url(<?php echo $image['url']; ?>)"></div>
												</a>
											<?php endif; ?>
										</div>
										
										<div class="col-sm-6 slider-nav hidden-xs transition">
											<a href="#carousel-location" data-slide="next">
												<div class="thumbnail-200 thumbnail-cover" style="background-image:url(<?php if(isset($location_gallery[$key + 1])) echo $location_gallery[$key + 1]['url']; else echo $location_gallery[0]['url']; ?>)"></div>
											</a>
										</div>
									</div>
									
									<div class="slider-controls text-center">
										<a class="slider-control-left" href="#carousel-location" role="button" data-slide="prev"></a>
										<a class="slider-control-right" href="#carousel-location" role="button" data-slide="next"></a>
									</div>
								</div>
								<?php $i++;
							} ?>
						</div>
					</div>
				<?php } ?>
			</div>
		</div>
	<?php } ?>
	
	<?php get_template_part( 'elements/parts/part', 'people' ); ?>
	
</div>

<?php get_footer(); ?>
